/**
 * @fileoverview 重构appbox
 * @author crisweng
 */
var appBox = {};

appBox._loginPage = 'appLogin.html';
appBox._appData = {
	qzone: {
		appIcon: 'qzone',
		button: 'sidebar-qzone-button',
		iframe: 'sidebar-qzone',
		title: 'QQ空间',
		titleUrl: 'http://qzone.qq.com/',
		url: 'http://qz.qq.com/?origintype=4'
	},
	weibo: {
		appIcon: 'weibo',
		button: 'sidebar-weibo-button',
		iframe: 'sidebar-weibo',
		title: '腾讯微博',
		titleUrl: 'http://t.qq.com',
		url: 'http://radio.t.qq.com/open/t.php?sid=1278&pref=internal.qqbrowser'
	},
	pengyou: {
		appIcon: 'pengyou',
		button: 'sidebar-pengyou-button',
		iframe: 'sidebar-pengyou',
		title: '朋友网',
		titleUrl: 'http://home.pengyou.com/index.php?mod=home&ADTAG=qqbrowser',
		url: 'http://ptlogin2.pengyou.com/pengyou_qqbrowser'
	},
	caibei: {
		appIcon: 'caibei',
		button: 'sidebar-caibei-button',
		iframe: 'sidebar-caibei',
		title: 'QQ彩贝',
		titleUrl: 'http://cb.qq.com/?attach=200.2000.00.303.00',
		url: 'http://cb.qq.com/qqbrowser/index.html'
	},
	'qzone-appstore': {
		appIcon: 'qzone-appstore',
		button: 'sidebar-qzone-appstore-button',
		iframe: 'sidebar-qzone-appstore',
		title: '应用中心',
		titleUrl: 'http://rc.qzone.qq.com/appsetup?usersource=qqbrowser',
		url: 'http://qzs.qq.com/qzone/vas/app/qqbrowser/appstore.html'
	},
	stock: {
		appIcon: 'stock',
		button: 'sidebar-stock-button',
		iframe: 'sidebar-stock',
		title: '股市行情资讯',
		titleUrl: 'http://stockapp.finance.qq.com/pstock',
		url: 'http://stockapp.finance.qq.com/panel/index.php?check=4&key=toolbar&uin='
	},
	doubanfm: {
		appIcon: 'doubanfm',
		button: 'sidebar-doubanfm-button',
		iframe: 'sidebar-doubanfm',
		title: '豆瓣FM',
		titleUrl: 'http://douban.fm/',
		url: 'http://douban.fm/partner/sidebar'
	},
	note: {
		appIcon: 'note',
		button: 'sidebar-note-button',
		iframe: 'sidebar-note',
		title: '记事本',
		titleUrl: 'http://mail.qq.com/cgi-bin/login?fun=passport&delegate_url=%2Fcgi-bin%2Fnote_list%3Fcatid%3D0%26info%3D1%26t%3Dnote_first_page%26loc%3Dnote_sidebar%2C%2C%2C32',
		url: 'http://mail.qq.com/cgi-bin/login?fun=passport&from=tb&action=note_sidebar&delegate_url=%2Fcgi-bin%2Fnote_list%3Fcatid%3D0%26info%3D1%26t%3Dnotepad_index_soso%26notepadsoso%3Dtrue%26QBsidebar%3Dtrue'
	},
	webgame: {
		appIcon: 'webgame',
		button: 'sidebar-webgame-button',
		iframe: 'sidebar-webgame',
		title: '腾讯网页游戏&社交游戏专区',
		titleUrl: 'http://wy.qq.com/',
		url: 'http://wy.qq.com/wymedia/qqbrowser/index.htm'
	},
	chongzhi: {
		appIcon: 'chongzhi',
		button: 'sidebar-chongzhi-button',
		iframe: 'sidebar-chongzhi',
		title: '充值中心',
		titleUrl: 'http://chong.paipai.com?ptag=31463.33.6',
		url: 'http://www.paipai.com/chong/portalApp.shtml'
	}
};

appBox._configName = 'appButtonId';
appBox._configDockShow = 'sidebarDockShow';
appBox._configMainSwitch = 'sidebarMainSwitch';
appBox._configQzoneSwitch = 'sidebarQzoneSwitch';
appBox.currUin=0;
appBox.firstNavigate = true;
appBox.isEnvChange = false;
appBox.isSTReady = false;
appBox.mainClose = false;		//true是关闭消息提醒，false是开放消息提醒
appBox.qzoneClose = false;
appBox.timer = null;
var _this = appBox;
var isTryInitLogon = true;
var getId = function(id){return document.getElementById(id)};
var query = function(id){return document.querySelector(id)};
_this.initialize = function(){

    getId('app-closebtn').addEventListener("click",function() {
    //Todo 与c++交互
        var frame = query("iframe.show");
        if(frame){
           frame.src = "";
            frame.setAttribute("first","true");
            frame = null;
           //frame.parentNode.removeChild(frame);
           window.external.SidebarCmd('closeApp','notify');

        }
    },false);
    getId("app-refreshbtn").addEventListener("click",function(){
        var frame = query("iframe.show"),src ="";
        if(frame){
            var url = frame.getAttribute("url");
            src = frame.src;
            frame.src = "";
            if (frame.getAttribute("needlogon") === "true") {
                url && window.external.SidebarCmd(url, '');
            } else {
                _this.sidebarUrlRedirect(src);
            }

            frame = null;
            window.external.SidebarCmd('refreshApp','notify');
        }

    },false);
   //监听后台发送的打开哪一个button
    isTryInitLogon = true;
    window.external.SidebarCmd('selectApp','notify');//主动向皮肤发送请求loadApp

};
_this.showApp = function(appButton) {
    if(!appButton) {
        return;
    }
    query('iframe.show')&&query('iframe.show').removeClass('show'); //隐藏先前的iframe
    _this.show('app-title'); //显示名称
    _this.show('app-icon'); //显示icon
    var iframeId = appButton.replace('-button', ''); // 获取iframe id
    var appId = iframeId.replace('sidebar-', ''); // 获取app id
    var iframe = getId(iframeId);
    if(iframe){
        iframe.addClass('show');
        _this.updatePanel(appId);
    }else{
        _this.createFrame(appId);
        _this.updatePanel(appId);
        iframe = getId(iframeId);
    }
    var url = iframe.getAttribute("url");
//不需要登录即可打开
if('false' == iframe.getAttribute('NeedLogon')) {
    _this.show(getId('app-header'));
    if(iframe.getAttribute('src') != url) {
        this.startLoadAnimation();
        iframe.src = url;
        iframe.onload = _this.stopLoadAnimation;
		setTimeout(function() {
			_this.stopLoadAnimation();
		}, 5000); 
    }
    iframe = null;
    return;
}
//登录判断
if(_this.getLogon()) {
    try {
        if(iframe.getAttribute('src') != url) {
            _this.show(getId('app-header'));
            if ('true' == iframe.getAttribute('first')){
                window.external.SidebarCmd(url, '');
                iframe.setAttribute('first','false');
            }
        }
    } catch(e) {}
} else {
    _this.hide(getId('app-header'));
    if(iframe.getAttribute('src') != _this._loginPage) {
        _this.stopLoadAnimation();
        iframe.src =  _this._loginPage;
    }
}
    iframe=null;
};
_this.createFrame = function(appId){

    var iframe = document.createElement("IFRAME");
    iframe.setAttribute("id",_this._appData[appId]['iframe']);
    iframe.style.border="none";
    iframe.setAttribute("url",_this._appData[appId]['url']);
    iframe.scrolling ="yes";
    iframe.frameBorder = "no";
    iframe.setAttribute("first","true");

    if(appId == "doubanfm"||appId == "webgame"){
        iframe.setAttribute("NeedLogon","false");
    }else{
        iframe.setAttribute("NeedLogon","true");
    }
    iframe.addClass("show");

    getId('appbox-content-wrapper').appendChild(iframe);
    iframe = null;
};
_this.updatePanel = function(appId){
    getId('app-icon').setClass(appId);
    // 设置title
    getId('app-title').innerHTML = "<a target='_blank' class='a-title' href='" + _this._appData[appId]['titleUrl'] + "'>" + _this._appData[appId]['title'] + "</a>";
    _this.show(getId('app-panel'));
};
_this.logon = function() {
    _this.setLogon();

    var iframe = query('iframe.show');
    if(iframe.length == 0) {
        iframe = query('#appbox-content-wrapper iframe:first-child');
    }
    iframe.setAttribute('first','true');

  //豆瓣电台特殊处理，不需要登录即可打开
    if('false' == iframe.getAttribute('NeedLogon')) {
        return;
    }

    _this.show(getId('app-header'));

   iframe.setAttribute('scrolling','yes');
   var url = iframe.getAttribute('url');
   try {
        if ('true' == iframe.getAttribute('first')){
            window.external.SidebarCmd(url, '');
            iframe.setAttribute('first','false');
        }
       iframe = null;
    } catch(e) {}
};
_this.logout = function() {
    _this.clearLogon();
    var iframe = query('iframe.show');

    if(!iframe) {
        iframe = query('#appbox-content-wrapper iframe:first-child');
    }

     //登录态随环境变化
    if('true' == iframe.getAttribute('NeedLogon')) {
        _this.hide(getId('app-header'));
        _this.stopLoadAnimation();
        iframe.src= _this._loginPage;
     }
    iframe = null;
};
  /*显示和隐藏元素*/
_this.hide = function(element){
    element = typeof(element)=="string"?getId(element):element;

    element && (element.style.display = "none");
};
_this.show = function(element){
    element = typeof(element)=="string"?getId(element):element;
    element && (element.style.display = "-webkit-box");
};

//appbox是否为登录页操作
_this.setLogon = function() {
    getId('appbox').setAttribute('logon', true);
};

_this.clearLogon = function() {
    getId('appbox').setAttribute('logon', false);
};

_this.getLogon = function() {
    return getId('appbox').getAttribute('logon') == 'true';
};

_this.sidebarUrlRedirect = function(url) {
    var iframe = query('iframe.show');
    setTimeout(function() {
        _this.startLoadAnimation();
        iframe && (iframe.src = url);
        iframe.onload = _this.stopLoadAnimation;
		setTimeout(function() {
			_this.stopLoadAnimation();
		}, 5000); 
        iframe = null;
    }, 0);

    // 导航
};
_this.getQzoneSwitchCallback = function(results) {
    var config =  JSON.parse(results)[0];
    var configValue = config[_this._configQzoneSwitch];
    if(configValue) {
        _this.qzoneClose = true;
        if(_this.timer) {
            clearInterval(_this.timer);
        }
    } else {
        _this.qzoneClose = false;
    }
};

_this.initialize();
/*qqbrowser.extension.onEvent.addListener(function(data) {
    configManager.getConfig([appBox._configMainSwitch], getMainSwitchCallback);
    configManager.getConfig([appBox._configQzoneSwitch], getQzoneSwitchCallback);
}, {evtOwner:'{80944EE7-D5ED-46f6-86DF-53FCE8B945AB}'});*/

_this.selectApp = function(appButton){
     _this.showApp(appButton);
    if(isTryInitLogon){
        window.external.SidebarCmd('','tryInitLogin');
        isTryInitLogon = false;
    }


};

_this.startLoadAnimation = function(){
    if (_this.loadIntervalId != -1) {
        clearInterval(_this.loadIntervalId);
        _this.loadIntervalId = -1;
    }
    if(_this.displayId != -1){
        clearTimeout(_this.displayId);
        _this.displayId = -1;
    }
    var eventWrapper = getId("appbox-event-wrapper");
    eventWrapper.removeClass("addTransition");
    eventWrapper.removeClass("hidden");
    eventWrapper.style.display = "-webkit-box";
    var imageIndex = 0;
    var appboxCenter = getId("appbox-center");
    _this.loadIntervalId = setInterval(function() {
        var position = [0,imageIndex*(-200)+"px"].join(" ");
        imageIndex = (imageIndex+1)%12;
        appboxCenter.style.backgroundPosition = position;

    }, 50);
};
_this.stopLoadAnimation = function() {
	if (_this.loadIntervalId != -1) { // 重复调用时，清除定时器
		clearInterval(_this.loadIntervalId);
		_this.loadIntervalId = -1;
	} else {
		return;
	}
   
    var eventWrapper = getId("appbox-event-wrapper");
    eventWrapper.addClass("addTransition");
    eventWrapper.addClass("hidden");
    _this.displayId = setTimeout(function(){eventWrapper.style.display = "none";},400);
};

